VERSION 5.00
Begin VB.Form fSimplePage 
   Caption         =   "Form1"
   ClientHeight    =   3105
   ClientLeft      =   60
   ClientTop       =   435
   ClientWidth     =   4680
   LinkTopic       =   "Form1"
   ScaleHeight     =   3105
   ScaleWidth      =   4680
   StartUpPosition =   3  'Windows-Standard
End
Attribute VB_Name = "fSimplePage"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'This small Demo was provided by Wolfgang Wolf, to give a
'short "Hello World"-like example, how to work with the
'Report-Classes of dhRichClient3

Option Explicit

Private Doc As cReportDocument
Private Page As cReportPage
Private picPreview As PictureBox
Private WithEvents cmdPrint As CommandButton
Attribute cmdPrint.VB_VarHelpID = -1


Private Sub Form_Load()

   Set Doc = New cReportDocument
   
   With Doc
    'setup the PageDimensions and the scale - default-scale is 1 (for 1 mm-Units)
    'and the default PageSize is A4 (210x297mm)
    .SetScaleAndPageDimensions 1, 210, 297
    'If you want to work with inch-based coords and Letter-Format, then the above should become:
    '.SetScaleAndPageDimensions 25.4, 8.5, 11
    'in this case you would have to adjust the drawing-coords
    '(which in this example work mm-based) to inches of course
    
      
      'create the needed Fonts within the Doc-Object first
      .AddFont "TitleFont", "Times New Roman", DotSize:=30, Bold:=True, Italic:=False
      .AddFont "VertraulichFont", "Arial Black", 30, True, False, DegToRotate:=15
      .AddFont "StrongFont", "Arial", 12, True
      .AddFont "DefaultFont", "Times New Roman", 12
      .AddFont "SmallFont", "Arial", 10
      '...same thing with the Pens
      .AddPen Key:="BlackPen_01", Size:=0.1, Color:=vbBlack    '0.1mm PenWidth
      .AddPen "BlackPen_04", 0.4, vbBlack                      '0.4mm PenWidth
   End With
   

   'create a Preview-PictureBox (using mm-Scaling on the Form)
   ScaleMode = vbMillimeters
   Set picPreview = Controls.Add("VB.PictureBox", "picPreview")
   With picPreview
      .Width = Doc.PageWidth / 2       '50%
      .Height = Doc.PageHeight / 2     '50%
      .AutoRedraw = True
      .BackColor = vbWhite
      .BorderStyle = vbBSNone
      .ScaleMode = vbPixels
      .Visible = True
   End With
   
   'create a Command-Button dynamically (using Twips again on our Form)
   ScaleMode = vbTwips
   Set cmdPrint = Controls.Add("VB.CommandButton", "cmdPrint")
   With cmdPrint
      .Caption = "&Drucken"
      .Move 0, 0, 900, 330
      .Visible = True
   End With
   
   'adapt the Form-Dimension to the PicPreview-Size
   Const WindowMargin = 600
   Dim marginW As Integer: marginW = (Width - ScaleWidth)
   Dim marginH As Integer: marginH = (Height - ScaleHeight)
   picPreview.Move WindowMargin, WindowMargin
   Width = picPreview.Width + (2 * WindowMargin) + marginW
   Height = picPreview.Height + (2 * WindowMargin) + marginH
   Move (Screen.Width - Width) / 2, (Screen.Height - Height) / 2
   
   BackColor = &H8000000C
   Caption = "SimplePrintDemo with Preview"
   
   Call CreateSimplePage 'and finally we create the ReportPage
End Sub

Private Sub CreateSimplePage()
Dim dtWidth As Integer, dtHeight As Integer
Dim dtText As String

   Set Page = Doc.AddPage

dtText = "Damit Ihr indess erkennt, woher dieser ganze Irrthum gekommen ist, und weshalb man die Lust anklagt und den Schmerz lobet, " & _
         "so will ich Euch Alles erffnen und auseinander setzen, was jener Begrnder der Wahrheit und gleichsam Baumeister des glcklichen " & _
         "Lebens selbst darber gesagt hat. Niemand, sagt er, verschmhe, oder hasse, oder fliehe die Lust als solche, sondern weil grosse Schmerzen " & _
         "ihr folgen, wenn man nicht mit Vernunft ihr nachzugehen verstehe. Ebenso werde der Schmerz als solcher von Niemand geliebt, gesucht und verlangt, " & _
         "sondern weil mitunter solche Zeiten eintreten, dass man mittelst Arbeiten und Schmerzen eine grosse Lust sich zu verschaften suchen msse. " & _
         "Um hier gleich bei dem Einfachsten stehen zu bleiben, so wrde Niemand von uns anstrengende krperliche Uebungen vornehmen, wenn er nicht einen " & _
         "Vortheil davon erwartete. Wer drfte aber wohl Den tadeln, der nach einer Lust verlangt, welcher keine Unannehmlichkeit folgt, oder der einem Schmerze " & _
         "ausweicht, aus dem keine Lust hervorgeht?" & vbCrLf & vbCrLf & _
         "Dagegen tadelt und hasst man mit Recht Den, welcher sich durch die Lockungen einer gegenwrtigen Lust erweichen und verfhren lsst, ohne in seiner " & _
         "blinden Begierde zu sehen, welche Schmerzen und Unannehmlichkeiten seiner deshalb warten. Gleiche Schuld treffe Die, welche aus geistiger Schwche, " & _
         "d.h. um der Arbeit und dem Schmerze zu entgehen, ihre Pflichten verabsumen. Man kann hier leicht und schnell den richtigen Unterschied treffen; " & _
         "zu einer ruhigen Zeit, wo die Wahl der Entscheidung vllig frei ist und nichts hindert, das zu thun, was den Meisten gefllt, hat man jede Lust zu " & _
         "erfassen und jeden Schmerz abzuhalten; aber zu Zeiten trifft es sich in Folge von schuldigen Pflichten oder von sachlicher Noth, dass man die Lust " & _
         "zurckweisen und Beschwerden nicht von sich weisen darf. Deshalb trifft der Weise dann eine Auswahl, damit er durch Zurckweisung einer Lust dafr " & _
         "eine grssere erlange oder durch Uebernahme gewisser Schmerzen sich grssere erspare."


   With Page
      .InitDrawMode Landscape:=False          'set Orientation
      .SelectHandle "BlackPen_01"      'Select a Pen-Object, which we added previously to the Doc-Object
      .DrawRectangle 20, 10, .PageWidth - 30, .PageHeight - 20, CornerWidth:=3, CornerHeight:=3  'draw a rounded-rectangle
      .SelectHandle "TitleFont"           'Select another predefined Pen-Object by Key
      .TextOut 30, 20, "Memorandum"    'draw Page-Title-Text
      
      'Select different Font-Objects and render certain Texts
      .SelectHandle "StrongFont"
      .TextOut 30, 45, "An:"
      .TextOut 30, 50, "CC:"
      .TextOut 30, 55, "Von:"
      .TextOut 30, 60, "Datum:"
      .TextOut 30, 65, "Betreff:"
      .SelectHandle "DefaultFont"
      .TextOut 50, 45, "[hier den Namen eingeben]"
      .TextOut 50, 50, "[hier den Namen eingeben]"
      .TextOut 50, 55, "[hier den Namen eingeben]"
      .TextOut 50, 60, Format$(Now, "Short Date")
      .TextOut 50, 65, "[hier den Betreff eingeben]"
      
      'horizontal line
      .SelectHandle "BlackPen_04"
      .DrawLine X1:=30, Y1:=85, X2:=.PageWidth - 20, Y2:=85  'Linie zeichnen
      'calc Text-Height and render
      .SelectHandle "DefaultFont"
      dtWidth = .PageWidth - (30 + 20)
      dtHeight = .CalcDrawTextRows(dtWidth, dtText) * .TextHeight
      .DrawText 30, 100, dtWidth, dtHeight, dtText, False, 0
      
      .SelectHandle "VertraulichFont", TextColor:=vbRed 'select the rotated Font-Object
      .TextOut .PageWidth / 2, 100 + dtHeight + 20, "V E R T R A U L I C H ", vbCenter
      
      'finally the Footer
      .SelectHandle "SmallFont", TextColor:=vbBlack
      'Footer-Text left-aligned
      .TextOutBaseLine 20, .PageHeight - 5, "Autor: [Autor]"
      'Footer-Text right-aligned
      .TextOutBaseLine .PageWidth - 10, .PageHeight - 5, "Seite " & .PageNumber, vbRightJustify
   End With
   RefreshPage
End Sub

Private Sub RefreshPage()
Dim QDIB As cDIB, BBuf As cDIB, BDC As cDC
Dim dx&, dy&, OverScan&
  picPreview.ScaleMode = vbPixels
  dx = picPreview.ScaleWidth: dy = picPreview.ScaleHeight
  If dx < 2 Or dy < 2 Then Exit Sub

  'now the rendering of the page-content to an InMemory-DC first
  'which got an appropriate DIB "selected into", done over
  'the cDC and cDIB-Classes which are also available in the toolset
  Set BBuf = New cDIB
  Set BDC = New cDC
  
  OverScan = 1
  If dx < 2560 And dy < 2560 Then OverScan = 2
  If dx < 1280 And dy < 1280 Then OverScan = 4
  
  BBuf.Resize dx * OverScan, dy * OverScan
  BBuf.Fill vbWhite
  BDC.SelectDIB BBuf.hDIB
    'here we render the EMF-content into our large DIB
    Page.RenderTo BDC.hDC, 0, 0, BBuf.dx - 1, BBuf.dy - 1
  BDC.DeSelectDIB
  
  'the Quarter-Methods achieve a similar effect as
  'StretchBlt-Mode HalfTone, which can be avoided this
  'way (because it is not available on all Win-Versions)
  If OverScan = 1 Then Set QDIB = BBuf
  If OverScan > 1 Then Set QDIB = BBuf.GetQuarterDIB
  If OverScan = 4 Then Set QDIB = QDIB.GetQuarterDIB
  
  If OverScan > 1 Then QDIB.Sharpen 'a final sharpen-call on the smaller DIB...
  QDIB.DrawTo picPreview.hDC '...before we draw it to a real Screen-DC
  
  picPreview.Refresh
End Sub


Private Sub cmdPrint_Click()
  'print the page on the current Default-Printer
   On Error GoTo cmdPrint_Click_Error
   Doc.PrintPages DocName:=Me.Caption
   Exit Sub

cmdPrint_Click_Error:
   MsgBox "Fehler " & Err.Number & " in Procedure cmdPrint_Click:" & vbCrLf & vbCrLf & Err.Description
End Sub

